// ***********************************************
// An Introduction to Computational Macroeconomics
// A. Bongers, T. Gmez and J. L. Torres (2019)
// The Ramsey model in DYNARE
// File: m10d.mod
// *********************************************
// Endogenous variables
var y, c, i, k, W, R;
// Exogenous variables
varexo A;
// Parameters
parameters alpha, beta, delta, n;
// Calibration
alpha = 0.35;
beta  = 0.97;
delta = 0.06;
n     = 0.01;
// Defining capital stock as predetermined (state) variable
predetermined_variables k;
// Model equations
model;
1	=	beta*((c/c(+1))*(R(+1)+(1-delta)));
y	= 	A*(k^alpha);
k(+1)	=	(1-delta-n)*k+i;
i	=	y-c;
W	=	(1-alpha)*y;
R	= 	alpha*A*(k^(alpha-1));
end;
// Initial values
initval;
y = 1; 
c = 0.8; 
k = 3.5;
i = 0.2;
W = (1-alpha)*y;
R = alpha*A*(k^(alpha-1));
A = 1;
end;
// Initial Steady State
steady;
ybar0=oo_.steady_state(1);
cbar0=oo_.steady_state(2);
ibar0=oo_.steady_state(3);
kbar0=oo_.steady_state(4);
Wbar0=oo_.steady_state(5);
Rbar0=oo_.steady_state(6);
// Stability conditions
check;
// Final values
endval;
y = 1; 
c = 0.8; 
k = 3.5;
i = 0.2;
W = (1-alpha)*y;
R = alpha*A*(k^(alpha-1));
A = 1.05;
end;
// New Steady State
steady;
ybar1=oo_.steady_state(1);
cbar1=oo_.steady_state(2);
ibar1=oo_.steady_state(3);
kbar1=oo_.steady_state(4);
Wbar1=oo_.steady_state(5);
Rbar1=oo_.steady_state(6);
simul(periods=58);
% Graphics
T=58;
j=1:T+2;
subplot(2,2,1)
plot(j,y,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Output per capita','FontName','Times')
subplot(2,2,2)
plot(j,k,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Capital stock per capita','FontName','Times')
subplot(2,2,3)
plot(j,c,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Consumption per capita','FontName','Times')
subplot(2,2,4)
plot(j,i,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Investment per capita','FontName','Times')