% ***********************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% Dynamic IS-LM model in DYNARE
% File: m2d.mod
% ***********************************************
// Endogenous variables
var p y yd i dy dp;
// Exogenous variables
varexo m, beta0, ybar0;
// Parameters
parameters psi, theta, beta1, mi, ni;
theta   =   0.5;
psi     =   0.05;
beta1   =   50;
mi      =   0.01;
ni      =   0.2;
// The model
model;
m-p=psi*y-theta*i;
yd=beta0-beta1*(i-dp);
dp=mi*(y-ybar0);
dy=ni*(yd-y);
dp(-1)=p-p(-1);
dy(-1)=y-y(-1);
end;
// Initial values
initval;
y       = ybar0;
yd      =    y;
p       =    1;
i       =    1;
dy      =   0;
dp      =   0;
m       = 100;
beta0   = 2100;
ybar0   = 2000;
end;
// Initial Steady State
steady;
check;
// Final values
endval;
y       = ybar0;
yd      =    y;
p       =    1;
i       =    1;
dy      =   0;
dp      =   0;
m       = 101;
beta0   = 2100;
ybar0   = 2000;
end;
// Final Stady State
steady;
// Shock analysis
shocks;
 var m;
 periods 0;
 values 0;
end;
// Numerical solution
simul(periods=30);
// Graphics
T=31;
j=1:T;
subplot(2,2,1)
plot(j,y,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Output','FontName','Times')
subplot(2,2,2)
plot(j,yd,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Aggregate demand','FontName','Times')
subplot(2,2,3)
plot(j,p,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Prices','FontName','Times')
subplot(2,2,4)
plot(j,i,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Nominal interest rate','FontName','Times')
