%*****************************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% Consumption-saving and consumption-leisure decisions
% Utility function: U=gamma*ln(C)+(1-gamma)*ln(1-L)
% File: m5.m. Auxiliary function: m5foc.m
%*****************************************************
clear all
% Parameters
T       =   30;     % Household's lifespan
beta    =   0.97; 	% Discount factor
gamma   =   0.40;   % Consumption weight in utility
% Variables exgenas
R       =   0.02; 	% Real interest rate
for t=1:T;
    W(t)    =   30+t-1; % Salary
end
par	=	[T beta R gamma W];
save par par;
% Initial (guess) values
x0	=	[10*ones(size(1:T)), 0.3*ones(size(1:T))]'; 
% Algorithm
sol	=	fsolve('m5foc',x0);
% Solution
for t=1:T
    	C(t)	=   sol(t);
        L(t)    =   sol(t+T);
end
for t=2:T;
	B(1) =	W(1)*L(1)-C(1);
	B(t) =	(1+R)*B(t-1)+W(t)*L(t)-C(t);
end
% Graphics
subplot(2,2,1)
plot(C,'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Consumption')
xlabel('Periods')
subplot(2,2,2)
plot(B,'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Saving (Stock of financial assets)')
xlabel('Periods')
subplot(2,2,3)
plot(W.*L,'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Labor income')
xlabel('Periods')
subplot(2,2,4)
plot(L,'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Labor (Fraction of time)')
xlabel('Periods')
