%*****************************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% Utility function: U=gamma*ln(C)+(1-gamma)*ln(1-L)
% File: m5foc.m. Script file: m5.m
%*****************************************************
function f=m5foc(x0,par)
% Loading parameters
load par
T       =   par(1);
beta    =   par(2);
R       =   par(3);
gamma   =   par(4);
for i=1:T;
W(i)    =   par(4+i);
end;
% Assignment of variables
for t=1:T
    C(t)    =   x0(t);
    L(t)    =   x0(t+T);
end
% Calculation of savings
for t=2:T-1;
B(1)    =   W(1)*L(1)-C(1);
B(t)    =   (1+R)*B(t-1)+W(t)*L(t)-C(t);
end
% Optimal consumption path   
f(1)        =   C(2)-beta*(1+R)*C(1);
f(2)        =   W(1)-(C(1)/((1-L(1))))*(1-gamma)/gamma;
for t=2:T-1
    f(2*t-1)    =   C(t+1)-beta*(1+R)*C(t);
    f(2*t)      =   W(t)-(C(t)/((1-L(t))))*(1-gamma)/gamma;
end
f(2*T)        =   C(T)-W(T)*L(T)-(1+R)*B(T-1);
f(2*T+1)      =   W(T)-(C(T)/((1-L(T))))*(1-gamma)/gamma;




